/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include "metypes.h"

#define DSP2ARM1		0xF804
#define DSP2ARM1B		0xF806
#define DSP2ARM1_FLAG 	0xF80E

void
dsp_announce(uint16 command, uint16 data)
{
    while (*(ioport uint16 *) DSP2ARM1_FLAG);

    *(ioport uint16 *) DSP2ARM1 = command;
    *(ioport uint16 *) DSP2ARM1B = data;
}
